function BlackMarketGui:populate_armor_skins(data)
	local new_data = {}
	local sort_data = {}
	local inventory_tradable = managers.blackmarket:get_inventory_tradable()

	for skin_id, skin_data in pairs(tweak_data.economy.armor_skins) do
		if skin_data.sorted == nil or skin_data.sorted then
			table.insert(sort_data, skin_id)
		end
	end

	table.sort(sort_data, function (a, b)
		local ad = tweak_data.economy.armor_skins[a]
		local bd = tweak_data.economy.armor_skins[b]
		local ar = tweak_data.economy.rarities[ad and ad.rarity or "common"].index
		local br = tweak_data.economy.rarities[bd and bd.rarity or "common"].index

		if ar ~= br then
			return br < ar
		elseif ad.sorting_idx or bd.sorting_idx then
			local as = ad.sorting_idx or -1
			local bs = bd.sorting_idx or -1

			if as ~= bs then
				return bs < as
			end
		end

		return managers.localization:text(ad and ad.name_id or "error") < managers.localization:text(bd and bd.name_id or "error")
	end)
	table.insert(sort_data, 1, "none")

	local guis_catalog = "guis/"
	local index = 0

	for i, skin_id in ipairs(sort_data) do
		local td = tweak_data.economy.armor_skins[skin_id]
		local category = td.category or "vanilla"
		if category == data.category or skin_id == "none" then
			local name_id = td.name_id or ""
			local unlocked = managers.blackmarket:armor_skin_unlocked(skin_id)

			if not unlocked then
				for _, data in pairs(inventory_tradable) do
					if data.entry == skin_id then
						unlocked = true

						break
					end
				end
			end

			guis_catalog = "guis/"
			local bundle_folder = td.texture_bundle_folder

			if bundle_folder then
				guis_catalog = guis_catalog .. "dlcs/" .. tostring(bundle_folder) .. "/"
			end

			index = index + 1
			local new_data = {
				name = skin_id,
				name_localized = managers.localization:text(name_id),
				category = "armor_skins",
				slot = index,
				unlocked = true,
				level = 0,
				equipped = skin_id == managers.blackmarket:equipped_armor_skin()
			}

			if i ~= 1 then
				new_data.bitmap_texture = guis_catalog .. "armor_skins/" .. skin_id
				new_data.bg_texture = managers.blackmarket:get_cosmetic_rarity_bg(td.rarity or "common")
			else
				new_data.button_text = managers.localization:to_upper_text("menu_casino_option_prefer_none")
			end

			new_data.comparision_data = {}
			new_data.lock_texture = self:get_lock_icon(new_data)
			new_data.cosmetic_unlocked = unlocked or false
			new_data.cosmetic_rarity = td.rarity

			if not new_data.cosmetic_unlocked then
				new_data.lock_texture = true
				new_data.bitmap_locked_blend_mode = "normal"
				new_data.bg_alpha = 0.4
			end

			if new_data.cosmetic_unlocked and not new_data.equipped then
				table.insert(new_data, "as_equip")
			end

			table.insert(new_data, "as_preview")
			table.insert(new_data, "as_workshop")

			data[index] = new_data
		end
	end

	local empty_slots_needed = data.override_slots[2] - ( index % data.override_slots[2] )

	if empty_slots_needed ~= data.override_slots[2] then
		for i = 1, empty_slots_needed, 1 do
			local new_data = {
				name = "empty",
				name_localized = "",
				category = "armors",
				slot = #data,
				unlocked = true,
				equipped = false
			}

			table.insert(data, new_data)
		end
	end
end

local function gatherArmorCategories( tweak_data )
	local categories = {}

	for key, armor_data in pairs(tweak_data) do
		local category = armor_data.category

		if category and not table.contains( categories, category ) then
			table.insert( categories, category )
		end
	end

	return categories
end

function BlackMarketGui:open_armor_skins_menu_callback(data)
	local new_node_data = {}

	local categories = gatherArmorCategories( tweak_data.economy.armor_skins )

	table.insert(new_node_data, {
		name = "bm_menu_vanilla_armor_skins",
		on_create_func_name = "populate_armor_skins",
		category = "vanilla",
		override_slots = {
			3,
			3
		},
		identifier = self.identifiers.armor_skins
	})

	for index, category in ipairs(categories) do
		table.insert(new_node_data, {
			name = "bm_menu_" .. category .. "_armor_skins",
			on_create_func_name = "populate_armor_skins",
			category = category,
			override_slots = {
				4,
				4
			},
			identifier = self.identifiers.armor_skins
		})
	end

	new_node_data.topic_id = "bm_menu_armor_skins"
	new_node_data.panel_grid_w_mul = 0.6
	new_node_data.skip_blur = true
	new_node_data.use_bgs = true
	new_node_data.hide_detection_panel = true

	managers.menu:open_node("blackmarket_armor_node", {new_node_data})
end